/*
 * carregaPropietaris.java
 *
 * Created on 6 de junio de 2008, 21:27
 */

package servlets;

import entitats.Client;
import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import org.apache.tools.ant.taskdefs.condition.IsSet;

/**
 *
 * @author Administrador
 * @version
 */
public class carregaPropietaris extends HttpServlet {
    
    Connection con = null;
    DataSource ds = null;
    ArrayList clients = new ArrayList();
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        this.doGet(request, response);
    }
    
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            clients.clear();
            
            String idClient = request.getParameter("id");
            Client c = new Client();
            c = (Client) request.getAttribute("Client");
            
            //Omple els camps del client que es podran modificar
            if (request.getParameter("id") != null){
                rs = st.executeQuery("SELECT * FROM clients WHERE id = "+idClient);
                rs.next();
                Client client = new Client();
                client.setIdClient(rs.getInt("id"));
                client.setNif(rs.getString("nif"));
                client.setNom(rs.getString("nom_o_rao_social"));
                if (rs.getString("cognoms") != null)
                    client.setCognoms(rs.getString("cognoms"));
                client.setTelefon(rs.getString("telefon"));
                client.setAdresa(rs.getString("adresa"));
                if (request.getAttribute("Client") != null)
                    client.setError(c.getError());
                request.setAttribute("Client", client);
            }
            
            //Comprova si hi ha algun atribut clients, i si no hi es omple un arraylist per mostrar tots els clients
            if ( request.getAttribute("clients") == null) {
                request.removeAttribute("client");
                Client client = new Client();
                
                if (request.getSession().getAttribute("usuariagent") != null)
                    rs = st.executeQuery("SELECT * FROM clients WHERE es_propietari = 1");
                else if (request.getSession().getAttribute("usuarivenedor") != null)
                    rs = st.executeQuery("SELECT * FROM clients WHERE es_llogater = 1");
                while (rs.next()) {
                    clients.add(new Client(rs.getInt("id"), rs.getString("nif"), rs.getString("nom_o_rao_social"), rs.getString("cognoms")));
                }
                
                rs.close();
                st.close();
                con.close();
                request.setAttribute("clients", clients);
            }
        } catch(Exception e) {
            System.out.println("SERVLET ERROR: " +e.getMessage() );
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
        
        RequestDispatcher rD = null;
        if (request.getParameter("action").equals("edicio"))
            rD = request.getRequestDispatcher("/modificacio_client.jsp");
        
        else if (request.getParameter("action").equals("baixa"))
            rD = request.getRequestDispatcher("/baixa_client.jsp");
        
        else if (request.getParameter("action").equals("alta_local"))
            rD = request.getRequestDispatcher("/CarregaZones?action=alta_local");
        rD.forward(request, response);
        
        out.close();
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
